/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.shells;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.DebugShell.DebugShellController;
import net.nooj4nlp.controller.DebugShell.KeySelectionTableActionListener;
import net.nooj4nlp.controller.DebugShell.MouseSelectionTableActionListener;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.gui.components.DebugJTableRenderer;
import net.nooj4nlp.gui.components.DebugJTreeRenderer;
import net.nooj4nlp.gui.main.Launcher;

public class DebugShell
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private GrammarEditorShellController controller;
    private DebugShellController debugController;
    private JTable tableTraces;
    private JTree treeDebug;
    private JComboBox comboExpression;
    private DebugJTableRenderer customTableRenderer;
    private DebugJTreeRenderer customTreeRenderer;

    public DebugShell(GrammarEditorShellController grammarController) {
        this.controller = grammarController;
        Font fontFromPreferences = Launcher.preferences.DFont;
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setClosable(true);
        this.setResizable(true);
        this.setTitle("Debug " + new File(this.controller.getFullName()).getName());
        this.setBounds(51, 51, 760, 300);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("ins 9", "[][grow][grow][grow][60:70:80]", "[::30][30:35:40][grow][75::]"));
        JLabel lbEnterExpression = new JLabel("Enter expression: ");
        this.getContentPane().add((Component)lbEnterExpression, "cell 0 0");
        this.comboExpression = new JComboBox();
        this.comboExpression.setPrototypeDisplayValue("XXX");
        this.comboExpression.setEditable(true);
        this.comboExpression.setFont(fontFromPreferences);
        this.comboExpression.setSelectedItem(new String(""));
        this.getContentPane().add((Component)this.comboExpression, "cell 1 0, gapleft 5, span 3, grow");
        JButton buttonDebug = new JButton("Debug");
        this.getContentPane().add((Component)buttonDebug, "cell 4 0, alignx center");
        JLabel lbExplanation = new JLabel("Click a solution below to display the corresponding path: ");
        this.getContentPane().add((Component)lbExplanation, "cell 0 1, span 2, grow");
        JLabel lbPerfect = new JLabel("Perfect");
        lbPerfect.setForeground(new Color(0, 128, 0));
        this.getContentPane().add((Component)lbPerfect, "cell 2 1, alignx center");
        JLabel lbPartial = new JLabel("Partial");
        lbPartial.setForeground(Color.BLUE);
        this.getContentPane().add((Component)lbPartial, "cell 3 1, alignx center");
        JLabel lbFailure = new JLabel("Failure");
        lbFailure.setForeground(Color.RED);
        this.getContentPane().add((Component)lbFailure, "cell 4 1, alignx center");
        DefaultTableModel tableModel = new DefaultTableModel(new Object[]{"Paths", "Outputs", "Tag"}, 0);
        this.tableTraces = new JTable(tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableTraces.setUI(new BasicTableUI(){

            @Override
            protected MouseInputListener createMouseInputListener() {
                return new BasicTableUI.MouseInputHandler(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            // empty if block
                        }
                    }
                };
            }
        });
        this.tableTraces.getTableHeader().setFont(fontFromPreferences);
        this.tableTraces.setFont(fontFromPreferences);
        this.tableTraces.removeColumn(this.tableTraces.getColumnModel().getColumn(2));
        this.tableTraces.setSelectionMode(1);
        this.customTableRenderer = new DebugJTableRenderer();
        this.tableTraces.setDefaultRenderer(Object.class, this.customTableRenderer);
        JScrollPane scrollPane = new JScrollPane(this.tableTraces, 20, 30);
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)scrollPane, "cell 0 2, span 5, growx");
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("");
        this.treeDebug = new JTree(top);
        this.treeDebug.setRootVisible(false);
        this.treeDebug.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        Icon subgraphIcon = null;
        renderer.setLeafIcon(subgraphIcon);
        renderer.setClosedIcon(subgraphIcon);
        renderer.setOpenIcon(subgraphIcon);
        this.treeDebug.setCellRenderer(renderer);
        JScrollPane treeView = new JScrollPane(this.treeDebug);
        this.getContentPane().add((Component)treeView, "cell 0 3, span 5, grow");
        this.customTreeRenderer = new DebugJTreeRenderer(Color.WHITE);
        this.treeDebug.setCellRenderer(this.customTreeRenderer);
        this.debugController = new DebugShellController(this, grammarController);
        buttonDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugShell.this.debugController.buttonPressedFunction();
            }
        });
        this.comboExpression.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DebugShell.this.debugController.comboPressedKeyEvent(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.tableTraces.addMouseListener(new MouseSelectionTableActionListener(this.debugController));
        this.tableTraces.addKeyListener(new KeySelectionTableActionListener(this.debugController));
        this.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                ((DebugShell)DebugShell.this).controller.debugShell = null;
                DebugShell.this.controller.getTimerDbg().stop();
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }
        });
    }

    public JTable getTableTraces() {
        return this.tableTraces;
    }

    public JTree getTreeDebug() {
        return this.treeDebug;
    }

    public JComboBox getComboExpression() {
        return this.comboExpression;
    }

    public DebugJTableRenderer getCustomTableRenderer() {
        return this.customTableRenderer;
    }

    public DebugJTreeRenderer getCustomTreeRenderer() {
        return this.customTreeRenderer;
    }
}

